
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  Timer.c: functions to implement real time measurement and delays
  Written by Nicholas Vinen, 2012-2013
*/

#include "Timer.h"
//#include "p33Fxxxx.h"

void Timer_Setup() {
  T1CONbits.TON = 1;
  T1CONbits.TCKPS = 2;
  TMR1 = 0;

  // T2CK = RC1/AN16
  TRISCbits.TRISC1 = 1;
  AD1PCFGHbits.PCFG16 = 1;
  T2CONbits.TON = 1;
  T2CONbits.TCKPS = 0;
  T2CONbits.TCS = 1;
  TMR2 = 0;

  T4CONbits.TON = 1;
  T4CONbits.TCKPS = 2;
  TMR4 = 0;
}

static unsigned long Timer_Fcy_cache;
static unsigned short Timer_CLKDIV_cache, Timer_OSCCON_cache, Timer_PLLFBD_cache;

unsigned long Timer_Get_Fcy() {
  if( Timer_CLKDIV_cache != CLKDIV || Timer_OSCCON_cache != OSCCON || Timer_PLLFBD_cache != PLLFBD ) {
    if( (OSCCON&0x7000) == 0 )
      Timer_Fcy_cache = 7370000UL / (1 << CLKDIVbits.FRCDIV) / 2;
    else
      Timer_Fcy_cache = 7370000UL / (1 << CLKDIVbits.FRCDIV) / (CLKDIVbits.PLLPRE + 2) * (PLLFBD + 2) / (CLKDIVbits.PLLPOST == 0 ? 2 : CLKDIVbits.PLLPOST == 1 ? 4 : 8) / 2;
    Timer_CLKDIV_cache = CLKDIV;
    Timer_OSCCON_cache = OSCCON;
    Timer_PLLFBD_cache = PLLFBD;
  }
  return Timer_Fcy_cache;
}

unsigned long Timer_Get_T1_frequency() {
  return Timer_Get_Fcy() / 64;
}

static void Timer_Delay_clocks(unsigned long clocks) {
  while( clocks > 65535 ) {
    TMR1 = 0;
    IFS0bits.T1IF = 0;
    while( !IFS0bits.T1IF )
      ;
    clocks -= 65535;
  }
  if( clocks ) {
    TMR1 = 0;
    IFS0bits.T1IF = 0;
    TMR1 = 65535 - clocks;
    while( !IFS0bits.T1IF )
      ;
  }
}

static void Timer_Delay_clocks_escape(unsigned long clocks, unsigned char* ptr, unsigned char value) {
  while( clocks > 65535UL ) {
    TMR1 = 0;
    IFS0bits.T1IF = 0;
    while( !IFS0bits.T1IF )
      if( *ptr == value )
        return;
    clocks -= 65536UL;
  }
  if( clocks ) {
    TMR1 = 0;
    IFS0bits.T1IF = 0;
    TMR1 = 65535 - clocks;
    while( !IFS0bits.T1IF )
      if( *ptr == value )
        return;
  }
}
	
void Timer_Delay_us(unsigned short us) {
  Timer_Delay_clocks( Timer_Get_T1_frequency() / 200 * us / 5000 );
}

void Timer_Delay_ms(unsigned short ms) {
  Timer_Delay_clocks( Timer_Get_T1_frequency() / 200 * ms / 5 );
}

void Timer_Delay_s(unsigned short s) {
  Timer_Delay_clocks( Timer_Get_T1_frequency() * s );
}

void Timer_Delay_ms_escape(unsigned short ms, unsigned char* ptr, unsigned char val) {
  Timer_Delay_clocks_escape( Timer_Get_T1_frequency() / 200 * ms / 5, ptr, val );
}
